CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    
	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'PDV_VD_IT' and column_name='CD_BARRAS') THEN 
		ALTER TABLE PDV_VD_IT
		ALTER COLUMN CD_BARRAS TYPE VARCHAR(50)
		USING CD_BARRAS::VARCHAR(50);
	END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
/*
##############################################
*/
DROP VIEW IF EXISTS v_nfce;

DROP VIEW IF EXISTS v_nfce_env;

DROP VIEW IF EXISTS v_nfce_venda;

SELECT addColumn();

DROP FUNCTION addColumn();


CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'Recriada';
BEGIN 

CREATE VIEW public.v_nfce_env
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.cd_cx,
    vd.cd_vd,
    vd.dt_vd,
    vd.nr_ecf,
    vd.cd_cli,
    vd.cgc_cpf,
    vd.nm_cli,
    vd.vlr_desc,
    vd.vlr_dinh,
    vd.vlr_chqs,
    vd.partner_promotion_id,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS vl_cartao
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6) AS vlr_cartao,
    ( SELECT COALESCE(sum(cred.vl_parc), 0::numeric) AS vl_crediario
           FROM pdv_vd_cred cred
          WHERE cred.cd_emp = vd.cd_emp AND cred.cd_filial = vd.cd_filial AND cred.cd_vd = vd.cd_vd) AS vlr_crediario,
    vd.vlr_tickets,
    vd.vlr_conv,
    vd.vlr_dup,
    vd.vlr_ncc,
    vd.st_vd,
    vd.vlr_conv_pbm,
    ( SELECT COALESCE(sum(it_1.vlr_liq_it), 0::numeric) AS vlr_liq_it
           FROM pdv_vd_it it_1
          WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_liq_it,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND ("substring"(tef.cod_modalidade::text, 1, 2) = '01'::text OR "substring"(tef.cod_modalidade::text, 1, 2) = '03'::text) AND tef.trn_pos <> 4 AND tef.trn_pos <> 5) AS vlr_cartao_debito,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND "substring"(tef.cod_modalidade::text, 1, 2) = '02'::text AND tef.trn_pos <> 4 AND tef.trn_pos <> 5) AS vlr_cartao_credito,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND tef.trn_pos = 4) AS vlr_qr_linx,
    ( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef tef
          WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND tef.trn_pos = 5) AS vlr_pix_scope,
	( SELECT COALESCE(sum(it_1.vlr_liq_it), 0::numeric) - vd.vlr_desc
           FROM pdv_vd_it it_1
          WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_liq_vd,
    ( SELECT COALESCE(sum(it_1.vlr_tot_it), 0::numeric) AS vlr_tot_it
           FROM pdv_vd_it it_1
          WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_bruto_it,
    it.cd_it,
    it.cd_barras AS ean,
    it.cd_prod,
        CASE
            WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN prod.ds_usual
            ELSE it.ds_prod_vd
        END AS ds_prod,
    prod.ncm_prod,
    med.ds_un AS cd_un_vd,
    it.qt_it,
    it.vlr_it,
    it.vlr_tot_it,
    it.vlr_desc_it,
    it.vlr_liq_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.tx_red_it,
    it.st_it,
    it.tipo_imposto,
    it.cd_vend,
    it.vlr_desc_tot_rat,
    vd.cd_nf_serie,
    vd.cd_usu,
    vd.vlr_imposto,
    vd.vlr_imposto_uf,
    vd.vlr_imposto_mun,
    vd.inf_cpl_nfce,
    vd.homolog_nfce,
    vd.url_danfe_nfce,
    nfce.chv_nfce,
    nfce.aut_nfce,
    nfce.sts_pend,
    nfce.ds_motivo,
    nfce.dt_cad AS dt_emi,
    vd.vlr_troco,
    nfce.xml_nfce,
    e.cod_ativacao_mfe,
    e.signacmfe,
    vd.end_cli,
    it.cd_prod_kit,
    it.nr_cest,
    it.vlr_frete_rat,
    vd.vlr_frete_tot,
    vd.nr_mfe
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
     JOIN est_nfce_env nfce ON vd.cd_emp = nfce.cd_emp::numeric AND vd.cd_filial = nfce.cd_filial::numeric AND vd.cd_nf_serie::text = nfce.cd_nf_serie::text AND vd.nr_ecf = nfce.cd_nf::numeric
     JOIN est_prod prod ON it.cd_emp = prod.cd_emp AND it.cd_prod = prod.cd_prod
     LEFT JOIN est_prod_un_med med ON prod.cd_emp = med.cd_emp AND prod.cd_un_vd = med.cd_ctr_un
     JOIN pdv_cx e ON e.cd_emp = vd.cd_emp AND e.cd_cx = vd.cd_cx AND e.cd_filial = vd.cd_filial;

  RAISE NOTICE 'v_nfce_env %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();

/*v_nfce*/

CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 

	CREATE OR REPLACE VIEW v_nfce
		AS SELECT cp.cd_emp,
			cp.cd_filial,
			cp.cd_cx,
			cp.cd_vd,
			cp.dt_vd,
			cp.nr_ecf,
			cp.cd_cli,
			cp.cgc_cpf,
			cp.nm_cli,
			cp.vlr_desc,
			cp.vlr_dinh,
			cp.vlr_chqs,
			cp.vlr_troco,
			cp.vlr_cartoes_linx,
			it.cd_benef,
			( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
				   FROM pdv_vd_tef item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_transacao <> 2::numeric AND item.tp_adm <> 6) AS vlr_cartao,
			( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
				   FROM pdv_vd_cred item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vlr_crediario,
			cp.vlr_tickets,
			cp.vlr_conv,
			cp.vlr_dup,
			cp.vlr_ncc,
			cp.st_vd,
			cp.vlr_conv_pbm,
			( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) AS "coalesce"
				   FROM pdv_vd_it item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_it,
			( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) - cp.vlr_desc
				   FROM pdv_vd_it item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_vd,
			( SELECT COALESCE(sum(item.vlr_tot_it), 0::numeric) AS "coalesce"
				   FROM pdv_vd_it item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_bruto_it,
			it.cd_it,
			it.cd_barras AS ean,
			it.cd_prod,
				CASE
					WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN p.ds_usual
					ELSE it.ds_prod_vd
				END AS ds_prod,
			p.ncm_prod,
			p.vlr_pmc,
			p.ctr_pmc,
			0 AS ean_trib,
			medidas.ds_un AS cd_un_vd,
			it.qt_it,
			it.vlr_it,
			it.vlr_tot_it,
			it.vlr_desc_it,
			it.vlr_liq_it,
			it.cd_trib_fc,
			it.tx_icms_it,
			it.tx_red_it,
			it.st_it,
			it.tipo_imposto,
			it.cd_vend,
			cp.cd_nf_serie,
			cp.cd_usu,
			cp.vlr_imposto,
			cp.vlr_imposto_uf,
			cp.vlr_imposto_mun,
			it.vlr_desc_tot_rat,
			it.nr_cest,
			COALESCE(p.nr_serv, ''::character varying) AS nr_serv,
			cp.hr_vd,
			cp.tipo_pbm,
			cp.tp_emis,
			pdv_cx.cod_ativacao_mfe,
			pdv_cx.signacmfe,
			COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
			COALESCE(it.perc_fecop_st, 0.0) AS perc_fecop_st,
			COALESCE(it.perc_fecop_ret, 0.0) AS perc_fecop_ret,
			COALESCE(it.perc_icms, 0.0) AS perc_icms,
			COALESCE(it.perc_icms_subst, 0.0) AS perc_icms_subst,
			COALESCE(it.perc_red_base_calc, 0.0) AS perc_red_base_calc,
			COALESCE(it.perc_red_base_calc_efet, 0.0) AS perc_red_base_calc_efet,
			COALESCE(it.perc_icms_efet, 0.0) AS perc_icms_efet,						
			COALESCE(it.perc_st, 0.0) AS perc_st,
			COALESCE(it.perc_icms_ret, 0.0) AS perc_icms_ret,
			Coalesce(it.motivo_desonerado_icms,0) as motivo_desonerado_icms,
			Coalesce(it.icms_desonerado, 0) as icms_desonerado,
			Coalesce(it.vlr_icms_desonerado_it, 0.0) as vlr_icms_desonerado_it,
			cp.regime_tributario,
			it.origem_produto,
			it.cfop,
			it.vlr_base_calc,  
			it.vlr_icms,
			it.vlr_base_subst, 
			it.vlr_isento,  
			it.vlr_outras,  
			it.vlr_icms_subst,
            it.vlr_fecop,
            it.vlr_fecop_st,
            it.vlr_fecop_ret,
			it.vlr_base_calc_efet,
			it.vlr_icms_efet,
			it.vlr_base_calc_ret,
			it.vlr_icms_ret,
			it.vlr_frete_rat,
            cp.vlr_frete_tot,
			pvo.tp_orc_entg as tp_orc_entg
		   FROM pdv_vd cp
			 JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
			 JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
			 JOIN pdv_cx ON cp.cd_emp = pdv_cx.cd_emp AND cp.cd_filial = pdv_cx.cd_filial AND cp.cd_cx = pdv_cx.cd_cx
			 LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un
			 
			 LEFT JOIN pdv_vd_orc pvo
			    ON pvo.cd_emp = cp.cd_emp
			   AND pvo.cd_filial = cp.cd_filial
			   AND pvo.cd_vd = cp.cd_vd;
			 
	RAISE NOTICE 'v_nfce Recriada.';
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();

/*v_nfce_venda*/

CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	CREATE OR REPLACE VIEW public.v_nfce_venda
	AS SELECT cp.cd_emp,
	    cp.cd_filial,
	    cp.cd_cx,
	    cp.cd_vd,
	    cp.dt_vd AS dt_cupom,
	    cp.nr_ecf,
	    cp.cd_cli,
	    cp.cgc_cpf,
	    cp.nm_cli,
	    cp.vlr_desc AS vl_desc_vd,
	    cp.vlr_dinh AS vl_dinh,
	    cp.vlr_chqs AS vl_chqs,
	    ( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
	           FROM pdv_vd_tef item
	          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vl_cartao,
	    ( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
	           FROM pdv_vd_cred item
	          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vl_crediario,
	    cp.vlr_tickets AS vl_tickets,
	    cp.vlr_conv AS vl_conv,
	    cp.vlr_dup AS vl_dup,
	    cp.vlr_ncc,
	    cp.st_vd AS st_cupom,
	    cp.vlr_conv_pbm,
	    cp.vlr_tot_prod AS vl_to_liq_it,
	    cp.vlr_liq_vd AS vl_to_liq_vd,
	    cp.vlr_vd AS vl_to_bruto_it,
	    it.cd_it,
	    COALESCE(it.cd_barras, '0'::character varying)::text AS ean,
	    it.cd_prod,
	    p.ds_prod,
	    p.ncm_prod,
	    0 AS ean_trib,
	    medidas.ds_un AS cd_un_vd,
	    it.qt_it,
	    it.vlr_it AS vl_unit,
	    it.qt_it * it.vlr_it AS vl_to_it,
	    it.qt_it * it.vlr_it - it.vlr_tot_it AS vl_desc_it,
	    it.vlr_tot_it AS vl_liq_it,
	    it.cd_trib_fc,
	    it.tx_icms_it,
	    it.tx_red_it,
	    it.st_it AS sts_prod,
	    it.tipo_imposto,
	    cp.cd_nf_serie,
	    cp.vlr_imposto,
	    cp.tx_med_imposto,
	    coalesce(it.perc_red_base_calc_efet,0) as perc_red_base_calc_efet_it,
		coalesce(it.perc_icms_efet,0) as perc_icms_efet_it,
		coalesce(IT.VLR_BASE_CALC_EFET,0) as VLR_BASE_CALC_EFET_IT,
		coalesce(IT.VLR_ICMS_EFET,0) as VLR_ICMS_EFET_IT,
		coalesce(CP.VLR_BASE_CALC_EFET ,0) as VLR_BASE_CALC_EFET_CAB,
		coalesce(CP.VLR_EFET_ICMS,0) as VLR_EFET_ICMS_CAB
	   FROM pdv_vd cp
	     JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
	     JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
	     LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un;
		 
	RAISE NOTICE 'v_nfce_venda Recriada.';
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();